﻿Imports System.IO
Imports System.Runtime.Remoting

Public Class MainForm
    '此函数循环访问通过
    'RemotingConfiguration.Configure(Remoting.config) 文件加载的所有 ClientActivatedService
    '类型。
    Private Sub ListClientActivatedServiceTypes()
        Dim entry As ActivatedServiceTypeEntry
        For Each entry In RemotingConfiguration.GetRegisteredActivatedServiceTypes()
            Me.lstOutput.Items.Add("Registered ActivatedServiceType: " & entry.TypeName)
        Next
    End Sub

    '此函数循环访问通过
    'RemotingConfiguration.Configure(Remoting.config) 文件加载的所有 WellKnownService
    '类型。
    Private Sub ListWellKnownServiceTypes()
        Dim entry As WellKnownServiceTypeEntry
        For Each entry In RemotingConfiguration.GetRegisteredWellKnownServiceTypes()
            Me.lstOutput.Items.Add(entry.TypeName & " is available at " & entry.ObjectUri)
        Next
    End Sub

    Private Sub frmMain_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Try
            '在 Host.exe.config 文件中读取
            '对 RemotingConfiguration.Configure 的调用在 xml 配置文件中加载，
            '并使远程处理结构了解通过远程处理使哪些类型可用
            Me.lstOutput.Items.Add("Loading Activated Configuration File")

            RemotingConfiguration.Configure("Host.exe.config", False)

            '加载 remoting.config 文件之后，枚举 ClientActivated
            '类型和 WellKnown 类型的列表，并在窗体的列表框中列出这两种类型。
            Me.ListClientActivatedServiceTypes()
            Me.ListWellKnownServiceTypes()

        Catch exp As Exception
            ' 捕获任意泛型异常
            Dim txt As String
            txt = "I was unable to load the file remoting.config or it is not in the correct format." & vbCrLf & _
             "Please make sure it is located in the same directory as this exe " & _
             " and that it is in the correct format." & vbCrLf & _
             "Please see the Help, About box for the location of this exe." & vbCrLf & vbCrLf & _
             "Detailed Error Information below:" & vbCrLf & vbCrLf & _
             "  Message: " & exp.Message & vbCrLf & _
             "  Source: " & exp.Source & vbCrLf & vbCrLf & _
             "  Stack Trace:" & vbCrLf & _
             exp.StackTrace

            MessageBox.Show(txt, "Generic Exception", MessageBoxButtons.OK, MessageBoxIcon.Stop)

            Me.lstOutput.Items.Add("Unabled to load objects.")
        End Try

    End Sub


End Class
